// ------------------------------------------------------------------
// Consultar NFSe por RPS (Betha)
// Padrão: Synapse (HTTPSend + ssl_openssl), usa TAutenticarAPI para Token
// ------------------------------------------------------------------
unit ConsultarNFSePorRPS;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils, httpsend, ssl_openssl, synautil,
  DOM, XMLRead, XMLWrite,
  Unimake, Variants, Dialogs;

type
  TConsultarNFSePorRPS = class
  public
    class procedure Executar;
  end;

implementation

class procedure TConsultarNFSePorRPS.Executar;
var
  Config, Servico: Variant;
  XMLDoc: TXMLDocument;
  Root, IdentificacaoRps, Prestador, CpfCnpj: TDOMElement;
  XMLStr: TStringStream;
  Retorno: WideString;
begin
  try
    // Inicializa DLL
    InicializarDLL;

    // Configuração do serviço
    Config := CreateOleObject('Unimake.Business.DFe.Servicos.Configuracao');
    Config.TipoDFe            := 3; // TipoDFe.NFSe
    Config.CertificadoArquivo := 'C:\\Projetos\\DLL com Python\\config\\Unimake_PV.pfx';
    Config.CertificadoSenha   := '12345678';
    Config.CodigoMunicipio    := 9999903;
    Config.TipoAmbiente       := 2; // Homologação
    Config.Servico            := 19; // Servico.NFSeConsultarNfsePorRps
    Config.SchemaVersao       := '2.02';

    // Montar XML
    XMLDoc := TXMLDocument.Create;
    Root := XMLDoc.CreateElement('ConsultarNfseRpsEnvio');
    Root.SetAttribute('xmlns', 'http://www.betha.com.br/e-nota-contribuinte-ws');
    XMLDoc.AppendChild(Root);

    // IdentificacaoRps
    IdentificacaoRps := XMLDoc.CreateElement('IdentificacaoRps');
    Root.AppendChild(IdentificacaoRps);
    IdentificacaoRps.AppendChild(XMLDoc.CreateElement('Numero')).AppendChild(XMLDoc.CreateTextNode('24'));
    IdentificacaoRps.AppendChild(XMLDoc.CreateElement('Serie')).AppendChild(XMLDoc.CreateTextNode('A1'));
    IdentificacaoRps.AppendChild(XMLDoc.CreateElement('Tipo')).AppendChild(XMLDoc.CreateTextNode('1'));

    // Prestador
    Prestador := XMLDoc.CreateElement('Prestador');
    Root.AppendChild(Prestador);
    CpfCnpj := XMLDoc.CreateElement('CpfCnpj');
    Prestador.AppendChild(CpfCnpj);
    CpfCnpj.AppendChild(XMLDoc.CreateElement('Cnpj')).AppendChild(XMLDoc.CreateTextNode('99999999999999'));
    Prestador.AppendChild(XMLDoc.CreateElement('InscricaoMunicipal')).AppendChild(XMLDoc.CreateTextNode('99999999999999'));

    // Converter para string
    XMLStr := TStringStream.Create('', TEncoding.UTF8);
    WriteXML(XMLDoc, XMLStr);

    // Enviar para a DLL
    Servico := CreateOleObject('Unimake.Business.DFe.Servicos.NFSe.ConsultarNfsePorRps');
    Servico.Executar(XMLStr.DataString, Config);

    // Exibir retorno
    Retorno := Servico.RetornoWSString;
    ShowMessage('XML retornado pela prefeitura:\n' + Retorno);

    XMLStr.Free;
    XMLDoc.Free;
  except
    on E: Exception do
    begin
      ShowMessage('Erro ao consultar NFSe por RPS: ' + E.Message);
      try
        ShowMessage('Exceção da DLL: ' + CreateOleObject('Unimake.Exceptions.ThrowHelper').GetMessage);
      except
        on Ex: Exception do
          ShowMessage('Erro secundário: ' + Ex.Message);
      end;
    end;
  end;
end;

end.
