// ------------------------------------------------------------------
// Gerar NFSe - Padrão NACIONAL
// ------------------------------------------------------------------
unit NACIONALGerarNFSe;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, ComObj, Dialogs;

type
  TNACIONALGerarNFSe = class
  public
    procedure Executar;
  end;

implementation

procedure TNACIONALGerarNFSe.Executar;
var
  // Declarar objetos
  oConfiguracao: olevariant;
  oGerarNFSe: olevariant;
  oExceptionInterop: olevariant;

  XML: string;
begin
  //Criar objeto para pegar exceção do lado do CSHARP
  oExceptionInterop := CreateOleObject('Unimake.Exceptions.ThrowHelper');

  try
    // Criar objeto de configuração mínima
    oConfiguracao := CreateOleObject('Unimake.Business.DFe.Servicos.Configuracao');
    oConfiguracao.TipoDFe := 5; //5=NFSe
    oConfiguracao.CertificadoArquivo := 'D:\projetos\certificados\DosClientes\CSJAugustoNFSe - Senha - Jabuticaba25.pfx';
    oConfiguracao.CertificadoSenha := 'Jabuticaba25';

    oConfiguracao.CodigoMunicipio := 1001058; //Padrão Nacional
    oConfiguracao.TipoAmbiente := 2; //Homologacao;
    oConfiguracao.Servico := 27; //NFSeGerarNFSe;
    oConfiguracao.SchemaVersao := '1.00';

    // XML montado manualmente (você pode gerar via string ou ler de arquivo também)
    XML :=
    '<?xml version="1.0" encoding="UTF-8"?>' +
    '<DPS versao="1.00" xmlns="http://www.sped.fazenda.gov.br/nfse">' +
    	'<infDPS Id="DPS330455723390606600010200001000000000000001">' +
    		'<tpAmb>2</tpAmb>' +
    		'<dhEmi>2025-12-03T11:59:00-03:00</dhEmi>' +
    		'<verAplic>202511</verAplic>' +
    		'<serie>1</serie>' +
    		'<nDPS>1</nDPS>' +
    		'<dCompet>2025-12-03</dCompet>' +
    		'<tpEmit>1</tpEmit>' +
    		'<cLocEmi>3304557</cLocEmi>' +
    		'<prest>' +
    			'<CNPJ>33906066000102</CNPJ>' +
    			'<fone>21964631967</fone>' +
    			'<email>awbinfo23@gmail.com</email>' +
    			'<regTrib>' +
    				'<opSimpNac>3</opSimpNac>' +
    				'<regApTribSN>3</regApTribSN>' +
    				'<regEspTrib>0</regEspTrib>' +
    			'</regTrib>' +
    		'</prest>' +
    		'<toma>' +
    			'<CNPJ>73911406000108</CNPJ>' +
                        '<xNome>ALF INFORMATICA LTDA</xNome>' +
    			'<end>' +
    				'<endNac>' +
    					'<cMun>3304557</cMun>' +
    					'<CEP>22240280</CEP>' +
    				'</endNac>' +
    				'<xLgr>RUA PADRE PERONEILLE</xLgr>' +
    				'<nro>700</nro>' +
    				'<xBairro>CENTRO</xBairro>' +
    			'</end>' +
    			'<email>testegmail@gmail.com</email>' +
    		'</toma>' +
    		'<serv>' +
    			'<locPrest>' +
    				'<cLocPrestacao>3304557</cLocPrestacao>' +
    			'</locPrest>' +
    			'<cServ>' +
    				'<cTribNac>040201</cTribNac>' +
    				'<xDescServ>exames medicos e de saúde em geral</xDescServ>' +
    			'</cServ>' +
    		'</serv>' +
    		'<valores>' +
    			'<vServPrest>' +
    				'<vServ>10.00</vServ>' +
    			'</vServPrest>' +
    			'<trib>' +
    				'<tribMun>' +
    					'<tribISSQN>1</tribISSQN>' +
    					'<tpRetISSQN>1</tpRetISSQN>' +
    				'</tribMun>' +
    				'<totTrib>' +
    					'<vTotTrib>' +
    						'<vTotTribFed>1.35</vTotTribFed>' +
    						'<vTotTribEst>0</vTotTribEst>' +
    						'<vTotTribMun>0.47</vTotTribMun>' +
    					'</vTotTrib>' +
    				'</totTrib>' +
    			'</trib>' +
    		'</valores>' +
    	'</infDPS>' +
    '</DPS>';

      oGerarNFse := CreateOleObject('Unimake.Business.DFe.Servicos.NFSe.GerarNFSe');
      oGerarNFSe.Executar(XML, IUnknown(oConfiguracao));

      DeleteFile('d:\testenfe\NacionalEnvioDPS.xml');
      with TStringList.Create do
      try
        Text := oGerarNFSe.GetConteudoXMLAssinado();
        SaveToFile('d:\testenfe\NacionalEnvioDPS.xml');
      finally
        Free;
      end;

      ShowMessage('XML retornado pela prefeitura:' + sLineBreak + oGerarNFSe.RetornoWSString);

      DeleteFile('d:\testenfe\NacionalRetornoEnvioDPS.xml');
      with TStringList.Create do
      try
        Text := oGerarNFSe.RetornoWSString;
        SaveToFile('d:\testenfe\NacionalRetornoEnvioDPS.xml');
      finally
        Free;
      end;

  except
    on E: Exception do
    begin
      ShowMessage('Erro ao gerar NFSe: ' + E.Message);
      ShowMessage(oExceptionInterop.GetMessage());
      ShowMessage(IntToStr(oExceptionInterop.GetErrorCode()));
    end;
  end;
end;

end.
