// ------------------------------------------------------------------
// Consulta situação NFe
// ------------------------------------------------------------------
unit ConsultarSituacaoNFe;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils, ComObj, Dialogs;

type
  TConsultarSituacaoNFe = class
  private

  public
    procedure Executar;
  end;

implementation

procedure TConsultarSituacaoNFe.Executar;
var
  oConfiguracao: olevariant;
  oConsSitNfe: olevariant;
  oConsultaProtocolo: olevariant;
  oExceptionInterop: olevariant;

  X: Integer;
  oProcEventoNFe: OleVariant;
  xmlEvento, nomeArqDistribEvento: string;
  nHandle: TFileStream;

begin
  // Criar objeto de configuração mínima
  oConfiguracao := CreateOleObject('Unimake.Business.DFe.Servicos.Configuracao');
  oConfiguracao.TipoDFe := 0; //0=NFe
  oConfiguracao.CertificadoArquivo := 'C:\Projetos\certificados\UnimakePV.pfx';
  oConfiguracao.CertificadoSenha := '12345678';

  //Criar objeto do XML
  oConsSitNfe := CreateOleObject('Unimake.Business.DFe.Xml.NFe.ConsSitNfe');
  oConsSitNfe.Versao := '4.00';
  oConsSitNfe.TpAmb  := 2;  // Homologação
  oConsSitNfe.ChNfe  := '35240110654122000155550010000085161700218900'; // Chave da NFE

  //Criar objeto para pegar exceção do lado do CSHARP
  oExceptionInterop := CreateOleObject('Unimake.Exceptions.ThrowHelper');

  try
    //Consumir o serviço
    oConsultaProtocolo := CreateOleObject('Unimake.Business.DFe.Servicos.NFe.ConsultaProtocolo');
    oConsultaProtocolo.Executar(IUnknown(oConsSitNfe), IUnknown(oConfiguracao));

    //String do XML retornado pela SEFAZ
    ShowMessage(oConsultaProtocolo.RetornoWSString);

    //Código de Status e Motivo
    ShowMessage(IntToStr(oConsultaProtocolo.Result.CStat) + ' - ' + oConsultaProtocolo.Result.XMotivo);

    //Extrair os eventos retornados na consulta situação da nota

  except
    ShowMessage(oExceptionInterop.GetMessage());
    ShowMessage(IntToStr(oExceptionInterop.GetErrorCode()));
  end;
end;

end.
