﻿# Helpers, Utilities and Extensions

Este pacote reúne um conjunto de ferramentas essenciais para facilitar o desenvolvimento de aplicações .NET, organizadas em quatro projetos principais:

## Projetos

### 1. Unimake.Extensions
🔸*nuget: https://www.nuget.org/packages/Unimake.Extensions*

Contém métodos de extensão para vários tipos comuns, como:

- **Tipos Genéricos**
- **DateTime**
- **Object**
- **List**
- **Entre outros**

Essas extensões visam tornar o código mais limpo e produtivo.

Para saber mais: https://github.com/Unimake/Helpers-UtilitiesAndExtensions

---
### 2. Unimake.Utils
🔸*nuget: https://www.nuget.org/packages/Unimake.Utils*

Inclui classes utilitárias e helpers diversos, como:

- **Validadores** (e.g., validação de documentos, formatos, etc.)
- **Formatadores** (de texto, números, datas, etc.)
- **Helpers gerais** para uso em diferentes cenários.

Para saber mais: https://github.com/Unimake/Helpers-UtilitiesAndExtensions

---
### 3. Unimake.Cryptography
🔸*nuget: https://www.nuget.org/packages/Unimake.Cryptography*

Concentra tudo relacionado à segurança e criptografia, incluindo:

- **Criptografia de dados**
- **Assinaturas**
- **Hashing** (SHA, MD5, etc.)
- JWT
- OAUTH

Para saber mais: https://github.com/Unimake/Helpers-UtilitiesAndExtensions

---
### 4. Unimake.Primitives
🔸*nuget: https://www.nuget.org/packages/Unimake.Primitives*

Agrupa tipos primitivos e estruturas que são amplamente reutilizadas em vários projetos Unimake, promovendo padronização e reuso.

Para saber mais: https://github.com/Unimake/Helpers-UtilitiesAndExtensions

---
## 📝 Quebrando as alterações

Consulte sempre o arquivo [**BREAKING CHANGES**](https://github.com/Unimake/Helpers-UtilitiesAndExtensions/blob/main/BREAKING_CHANGES.md) para garantir que seu código esteja sempre atualizado com as últimas mudanças.


